<?php
/**
 * Registers all block assets so that they can be enqueued through the block editor
 * in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/applying-styles-with-stylesheets/
 */
if ( ! function_exists( 'blockwheels_render_single_icon' ) ) {

	function blockwheels_render_single_icon( $attributes, $content ) {

		if ( isset( $attributes['blockId'] ) ) {

			$block_id 	= sanitize_text_field( $attributes['blockId'] );
			// now we generate the styles for wp_add_inline_style
			$inline_css = '';
			$fonts		= [];
			$selector 	= '.blockwheels-single-icon-wrapper[data-id="' . esc_attr( $block_id ) . '"]';
			$block_name = 'single-icon';
			$handle 	= 'blockwheels-' . $block_name . '-style';
			
			// Icon size
			if ( isset( $attributes['iconSize'] ) ) {
				$inline_css .= Blockwheels_CSS::get_range_css(
					$selector . ' .wp-block-icon i',
					$attributes['iconSize'],
					'font-size'
				);
			}
			// Icon BG Width
			if ( isset( $attributes['iconBgSize'] ) ) {
				$inline_css .= Blockwheels_CSS::get_range_css(
					$selector . ' .wp-block-icon i',
					$attributes['iconBgSize'],
					'width'
				);
				$inline_css .= Blockwheels_CSS::get_range_css(
					$selector . ' .wp-block-icon i',
					$attributes['iconBgSize'],
					'height'
				);
				$inline_css .= Blockwheels_CSS::get_range_css(
					$selector . ' .wp-block-icon i',
					$attributes['iconBgSize'],
					'line-height'
				);
			}
			// Border Radius
			if ( isset( $attributes['iconBorderRadius'] ) ) {
				$inline_css .= Blockwheels_CSS::get_generate_css(
					$selector . ' .wp-block-icon i',
					$attributes['iconBorderRadius'],
					'border-radius'
				);
			}
			// Icon color
			if ( isset( $attributes['iconColor'] ) ) {
				$inline_css .= Blockwheels_CSS::get_color_css(
					$selector . ' .wp-block-icon i',
					$attributes['iconColor'],
					'color'
				);
			}
			// Icon Background color
			if ( isset( $attributes['iconBgColor'] ) ) {
				$inline_css .= Blockwheels_CSS::get_color_css(
					$selector . ' .wp-block-icon i',
					$attributes['iconBgColor'],
					'background-color'
				);
			}
			// Icon Background gradient
			if ( isset( $attributes['iconBgGradient'] ) ) {
				$inline_css .= Blockwheels_CSS::get_color_css(
					$selector . ' .wp-block-icon i',
					$attributes['iconBgGradient'],
					'background-image'
				);
			}

			if ( $inline_css !== '' ) {
				$css = Blockwheels_CSS::minify( $inline_css );
				wp_add_inline_style( $handle, $css );
			}

			return $content;
		}
	}
}

if ( ! function_exists( 'blockwheels_register_single_icon' ) ) {

	function blockwheels_register_single_icon() {

		$block_name  		= 'single-icon';
		$asset_config_file 	= sprintf( '%s/build/blocks/icons/'. $block_name .'/index.asset.php', BLOCKWHEELS_PATH );
		if ( ! file_exists( $asset_config_file ) ) {
			return;
		}
	
		register_block_type(
			BLOCKWHEELS_PATH . 'build/blocks/icons/' . $block_name . '/block.json',
			array(
				'render_callback' 	=> 'blockwheels_render_single_icon'
			)
		);
	}
}
add_action( 'init', 'blockwheels_register_single_icon' );
